/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlClientChunkMap;
import qouteall.imm_ptl.core.ducks.IEBuiltChunk;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.GcMonitor;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class MyBuiltChunkStorage
extends ViewArea {
    private final ChunkRenderDispatcher factory;
    private final Long2ObjectOpenHashMap<Column> columnMap = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Preset> presets = new Long2ObjectOpenHashMap();
    private Preset currentPreset = null;
    public final int minSectionY;
    public final int endSectionY;
    private boolean isAlive = true;

    public static void init() {
        ImmPtlClientChunkMap.clientChunkUnloadSignal.connect(chunk -> {
            ViewArea viewArea;
            ResourceKey dimension = chunk.m_62953_().m_46472_();
            LevelRenderer worldRenderer = ClientWorldLoader.worldRendererMap.get(dimension);
            if (worldRenderer != null && (viewArea = ((IEWorldRenderer)worldRenderer).ip_getBuiltChunkStorage()) instanceof MyBuiltChunkStorage) {
                MyBuiltChunkStorage myBuiltChunkStorage = (MyBuiltChunkStorage)viewArea;
                myBuiltChunkStorage.onChunkUnload(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
            }
        });
    }

    public MyBuiltChunkStorage(ChunkRenderDispatcher chunkBuilder, Level world, int r, LevelRenderer worldRenderer) {
        super(chunkBuilder, world, r, worldRenderer);
        this.factory = chunkBuilder;
        IPGlobal.postClientTickSignal.connectWithWeakRef(this, MyBuiltChunkStorage::tick);
        int cacheSize = this.f_110841_ * this.f_110840_ * this.f_110842_;
        if (IPGlobal.cacheGlBuffer) {
            cacheSize /= 10;
        }
        this.minSectionY = McHelper.getMinSectionY((LevelAccessor)world);
        this.endSectionY = McHelper.getMaxSectionYExclusive((LevelAccessor)world);
    }

    protected void m_110864_(ChunkRenderDispatcher chunkBuilder_1) {
        this.f_110843_ = new ChunkRenderDispatcher.RenderChunk[this.f_110841_ * this.f_110840_ * this.f_110842_];
    }

    public void m_110849_() {
        Set<ChunkRenderDispatcher.RenderChunk> allActiveBuiltChunks = this.getAllActiveBuiltChunks();
        allActiveBuiltChunks.forEach(ChunkRenderDispatcher.RenderChunk::m_112838_);
        this.columnMap.clear();
        this.presets.clear();
        this.isAlive = false;
    }

    public void m_110850_(double playerX, double playerZ) {
        Minecraft.m_91087_().m_91307_().m_6180_("built_chunk_storage");
        int cameraBlockX = Mth.m_14107_((double)playerX);
        int cameraBlockZ = Mth.m_14107_((double)playerZ);
        int cameraChunkX = cameraBlockX >> 4;
        int cameraChunkZ = cameraBlockZ >> 4;
        ChunkPos cameraChunkPos = new ChunkPos(cameraChunkX, cameraChunkZ);
        Preset preset = (Preset)this.presets.computeIfAbsent(cameraChunkPos.m_45588_(), whatever -> this.createPresetByChunkPos(cameraChunkX, cameraChunkZ));
        preset.lastActiveTime = System.nanoTime();
        this.f_110843_ = preset.data;
        this.currentPreset = preset;
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public void m_110859_(int cx, int cy, int cz, boolean isImportant) {
        ChunkRenderDispatcher.RenderChunk builtChunk = this.provideBuiltChunkByChunkPos(cx, cy, cz);
        builtChunk.m_112828_(isImportant);
    }

    public ChunkRenderDispatcher.RenderChunk provideBuiltChunkByChunkPos(int cx, int cy, int cz) {
        Column column = this.provideColumn(ChunkPos.m_45589_((int)cx, (int)cz));
        int offsetChunkY = Mth.m_14045_((int)(cy - McHelper.getMinSectionY((LevelAccessor)this.f_110839_)), (int)0, (int)(McHelper.getYSectionNumber((LevelAccessor)this.f_110839_) - 1));
        return column.chunks[offsetChunkY];
    }

    private Preset createPresetByChunkPos(int chunkX, int chunkZ) {
        ChunkRenderDispatcher.RenderChunk[] chunks1 = new ChunkRenderDispatcher.RenderChunk[this.f_110841_ * this.f_110840_ * this.f_110842_];
        for (int cx = 0; cx < this.f_110841_; ++cx) {
            int xBlockSize = this.f_110841_ * 16;
            int xStart = (chunkX << 4) - xBlockSize / 2;
            int px = xStart + Math.floorMod(cx * 16 - xStart, xBlockSize);
            for (int cz = 0; cz < this.f_110842_; ++cz) {
                int zBlockSize = this.f_110842_ * 16;
                int zStart = (chunkZ << 4) - zBlockSize / 2;
                int pz = zStart + Math.floorMod(cz * 16 - zStart, zBlockSize);
                Validate.isTrue((px % 16 == 0 ? 1 : 0) != 0);
                Validate.isTrue((pz % 16 == 0 ? 1 : 0) != 0);
                Column column = this.provideColumn(ChunkPos.m_45589_((int)(px >> 4), (int)(pz >> 4)));
                for (int offsetCy = 0; offsetCy < this.f_110840_; ++offsetCy) {
                    int index = this.m_110855_(cx, offsetCy, cz);
                    chunks1[index] = column.chunks[offsetCy];
                }
            }
        }
        return new Preset(chunks1);
    }

    private void foreachPresetCoveredChunkPoses(int centerChunkX, int centerChunkZ, LongConsumer func) {
        ChunkRenderDispatcher.RenderChunk[] chunks1 = new ChunkRenderDispatcher.RenderChunk[this.f_110841_ * this.f_110840_ * this.f_110842_];
        for (int cx = 0; cx < this.f_110841_; ++cx) {
            int xBlockSize = this.f_110841_ * 16;
            int xStart = (centerChunkX << 4) - xBlockSize / 2;
            int px = xStart + Math.floorMod(cx * 16 - xStart, xBlockSize);
            for (int cz = 0; cz < this.f_110842_; ++cz) {
                int zBlockSize = this.f_110842_ * 16;
                int zStart = (centerChunkZ << 4) - zBlockSize / 2;
                int pz = zStart + Math.floorMod(cz * 16 - zStart, zBlockSize);
                Validate.isTrue((px % 16 == 0 ? 1 : 0) != 0);
                Validate.isTrue((pz % 16 == 0 ? 1 : 0) != 0);
                long chunkPos = ChunkPos.m_45589_((int)(px >> 4), (int)(pz >> 4));
                func.accept(chunkPos);
            }
        }
    }

    private int m_110855_(int x, int y, int z) {
        return (z * this.f_110840_ + y) * this.f_110841_ + x;
    }

    public Column provideColumn(long chunkPos) {
        return (Column)this.columnMap.computeIfAbsent(chunkPos, this::createColumn);
    }

    private Column createColumn(long chunkPos) {
        ChunkRenderDispatcher.RenderChunk[] array = new ChunkRenderDispatcher.RenderChunk[this.f_110840_];
        int chunkX = ChunkPos.m_45592_((long)chunkPos);
        int chunkZ = ChunkPos.m_45602_((long)chunkPos);
        int minY = McHelper.getMinY((LevelAccessor)this.f_110839_);
        for (int offsetCY = 0; offsetCY < this.f_110840_; ++offsetCY) {
            ChunkRenderDispatcher.RenderChunk builtChunk;
            ChunkRenderDispatcher chunkRenderDispatcher = this.factory;
            Objects.requireNonNull(chunkRenderDispatcher);
            array[offsetCY] = builtChunk = new ChunkRenderDispatcher.RenderChunk(chunkRenderDispatcher, 0, chunkX << 4, (offsetCY << 4) + minY, chunkZ << 4);
        }
        return new Column(array);
    }

    private void tick() {
        if (!this.isAlive) {
            return;
        }
        ClientLevel worldClient = Minecraft.m_91087_().f_91073_;
        if (worldClient != null) {
            if (GcMonitor.isMemoryNotEnough()) {
                if (worldClient.m_46467_() % 3L == 0L) {
                    this.purge();
                }
            } else if (worldClient.m_46467_() % 213L == 66L) {
                this.purge();
            }
        }
    }

    private void purge() {
        Minecraft.m_91087_().m_91307_().m_6180_("my_built_chunk_storage_purge");
        long dropTime = Helper.secondToNano(GcMonitor.isMemoryNotEnough() ? 3.0 : 20.0);
        long currentTime = System.nanoTime();
        this.presets.long2ObjectEntrySet().removeIf(entry -> {
            Preset preset = (Preset)entry.getValue();
            long centerChunkPos = entry.getLongKey();
            boolean shouldDropPreset = this.shouldDropPreset(dropTime, currentTime, preset);
            if (!shouldDropPreset) {
                this.foreachPresetCoveredChunkPoses(ChunkPos.m_45592_((long)centerChunkPos), ChunkPos.m_45602_((long)centerChunkPos), columnChunkPos -> {
                    Column column = (Column)this.columnMap.get(columnChunkPos);
                    column.mark = currentTime;
                });
            }
            return shouldDropPreset;
        });
        long timeThreshold = Helper.secondToNano(5.0);
        ArrayDeque toDelete = new ArrayDeque();
        this.columnMap.long2ObjectEntrySet().removeIf(entry -> {
            boolean shouldRemove;
            Column column = (Column)entry.getValue();
            boolean bl = shouldRemove = currentTime - column.mark > timeThreshold;
            if (shouldRemove) {
                toDelete.addAll(Arrays.asList(column.chunks));
            }
            return shouldRemove;
        });
        if (!toDelete.isEmpty()) {
            IPGlobal.preGameRenderTaskList.addTask(() -> {
                if (toDelete.isEmpty()) {
                    return true;
                }
                for (int num = 0; !toDelete.isEmpty() && num < 100; ++num) {
                    ChunkRenderDispatcher.RenderChunk builtChunk = (ChunkRenderDispatcher.RenderChunk)toDelete.poll();
                    builtChunk.m_112838_();
                }
                return false;
            });
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    private boolean shouldDropPreset(long dropTime, long currentTime, Preset preset) {
        if (preset.data == this.f_110843_) {
            return false;
        }
        return currentTime - preset.lastActiveTime > dropTime;
    }

    private Set<ChunkRenderDispatcher.RenderChunk> getAllActiveBuiltChunks() {
        HashSet<ChunkRenderDispatcher.RenderChunk> result = new HashSet<ChunkRenderDispatcher.RenderChunk>();
        this.presets.forEach((key, preset) -> result.addAll(Arrays.asList(preset.data)));
        if (this.f_110843_ != null) {
            result.addAll(Arrays.asList(this.f_110843_));
        }
        result.remove(null);
        return result;
    }

    public int getManagedSectionNum() {
        return this.columnMap.size() * this.f_110840_;
    }

    public String getDebugString() {
        return String.format("Built Section Storage Columns:%s", this.columnMap.size());
    }

    public int getRadius() {
        return (this.f_110841_ - 1) / 2;
    }

    public boolean isRegionActive(int cxStart, int czStart, int cxEnd, int czEnd) {
        for (int cx = cxStart; cx <= cxEnd; ++cx) {
            for (int cz = czStart; cz <= czEnd; ++cz) {
                if (!this.columnMap.containsKey(ChunkPos.m_45589_((int)cx, (int)cz))) continue;
                return true;
            }
        }
        return false;
    }

    public void onChunkUnload(int chunkX, int chunkZ) {
        long chunkPos = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        Column column = (Column)this.columnMap.get(chunkPos);
        if (column != null) {
            for (ChunkRenderDispatcher.RenderChunk builtChunk : column.chunks) {
                ((IEBuiltChunk)builtChunk).portal_fullyReset();
            }
        }
    }

    public ChunkRenderDispatcher.RenderChunk getSectionFromRawArray(BlockPos sectionOrigin, ChunkRenderDispatcher.RenderChunk[] chunks) {
        int i = Mth.m_14042_((int)sectionOrigin.m_123341_(), (int)16);
        int j = Mth.m_14042_((int)(sectionOrigin.m_123342_() - McHelper.getMinY((LevelAccessor)this.f_110839_)), (int)16);
        int k = Mth.m_14042_((int)sectionOrigin.m_123343_(), (int)16);
        if (j >= 0 && j < this.f_110840_) {
            i = Mth.m_14100_((int)i, (int)this.f_110841_);
            k = Mth.m_14100_((int)k, (int)this.f_110842_);
            return chunks[this.m_110855_(i, j, k)];
        }
        return null;
    }

    @Nullable
    protected ChunkRenderDispatcher.RenderChunk m_110866_(BlockPos pos) {
        int i = Mth.m_14042_((int)pos.m_123341_(), (int)16);
        int j = Mth.m_14042_((int)(pos.m_123342_() - McHelper.getMinY((LevelAccessor)this.f_110839_)), (int)16);
        int k = Mth.m_14042_((int)pos.m_123343_(), (int)16);
        if (j >= 0 && j < this.f_110840_) {
            int chunkIndex = this.m_110855_(i = Mth.m_14100_((int)i, (int)this.f_110841_), j, k = Mth.m_14100_((int)k, (int)this.f_110842_));
            ChunkRenderDispatcher.RenderChunk result = this.f_110843_[chunkIndex];
            if (result == null) {
                Helper.err("Null RenderChunk " + String.valueOf(pos));
                return null;
            }
            ((IEBuiltChunk)result).portal_setIndex(chunkIndex);
            return result;
        }
        return null;
    }

    @Nullable
    public ChunkRenderDispatcher.RenderChunk rawFetch(int cx, int cy, int cz, long timeMark) {
        if (cy < this.minSectionY || cy >= this.endSectionY) {
            return null;
        }
        long l = ChunkPos.m_45589_((int)cx, (int)cz);
        Column column = this.provideColumn(l);
        column.mark = timeMark;
        int yOffset = cy - this.minSectionY;
        return column.chunks[yOffset];
    }

    @Nullable
    public ChunkRenderDispatcher.RenderChunk rawGet(int cx, int cy, int cz) {
        if (cy < this.minSectionY || cy >= this.endSectionY) {
            return null;
        }
        long l = ChunkPos.m_45589_((int)cx, (int)cz);
        Column column = (Column)this.columnMap.get(l);
        if (column == null) {
            return null;
        }
        int yOffset = cy - this.minSectionY;
        return column.chunks[yOffset];
    }

    public static class Preset {
        public final ChunkRenderDispatcher.RenderChunk[] data;
        public long lastActiveTime = 0L;

        public Preset(ChunkRenderDispatcher.RenderChunk[] data) {
            this.data = data;
        }
    }

    public static class Column {
        public long mark = 0L;
        public ChunkRenderDispatcher.RenderChunk[] chunks;

        public Column(ChunkRenderDispatcher.RenderChunk[] chunks) {
            this.chunks = chunks;
        }
    }
}

